<?php
/*
+--------------------------------------------------------------------------
|   CubeCart v3.0.10
|   ========================================
|   by Alistair Brookbanks
|	CubeCart is a Trade Mark of Devellion Limited
|   Copyright Devellion Limited 2005 - 2006. All rights reserved.
|   Devellion Limited,
|   22 Thomas Heskin Court,
|   Station Road,
|   Bishops Stortford,
|   HERTFORDSHIRE.
|   CM23 3EE
|   UNITED KINGDOM
|   http://www.devellion.com
|	UK Private Limited Company No. 5323904
|   ========================================
|   Web: http://www.cubecart.com
|   Date: Friday, 15 July 2005
|   Email: info (at) cubecart (dot) com
|	License Type: CubeCart is NOT Open Source Software and Limitations Apply 
|   Licence Info: http://www.cubecart.com/site/faq/license.php
+--------------------------------------------------------------------------
|	transfer.php
|   ========================================
|	Core functions for the GSPAY.COM Gateway	
+--------------------------------------------------------------------------
*/
/*
//////////////////////////
// AUTHORIZE.NET GATEWAY
//////////////////////////
// L@@K AT ALL THE LOVELY 
// VARIABLES WE HAVE TO
// PLAY WITH!!
//////

//////////////////////////
// IN THE REPEATED REGION
//////
$orderInv['productId']						- product id as an integer
$orderInv['name']							- product name as a varchar
$orderInv['price']							- price of each product (inc options)
$orderInv['quantity']						- quantity of products as an integer
$orderInv['product_options']				- products attributes as test
$orderInv['productCode']					- product code as a varchar
$i											- This is the current incremented integer starting at 0

/////////////////////////
// FIXED VARS
///////
$cart_order_id							- cart order id as a varchar
$ccUserData[0]['email']						- Customers email address
$ccUserData[0]['title']						- Customers title (Mr Miss etc...)
$ccUserData[0]['firstName']					- Customers first name
$ccUserData[0]['lastName']					- Customers last name 
$ccUserData[0]['add_1']						- Invoice Address line 1
$ccUserData[0]['add_2']						- Invoice Address line 1
$ccUserData[0]['town']						- Invoice Town or city
$ccUserData[0]['county']					- Invoice County or state
$ccUserData[0]['postcode']					- Invoice Post/Zip Code
$ccUserData[0]['country']					- Invoice country Id we can look up the country name like this
										countryName($ccUserData[0]['country']);
$ccUserData[0]['phone']						- Contact phone no
$ccUserData[0]['mobile']					- Mobile/Cell phone number

$basket['delInf']['title']				- Delivery title (Mr Miss etc...)
$basket['delInf']['firstName']			- Delivery customers first name
$basket['delInf']['lastName']			- Delivery customers last name 
$basket['delInf']['add_1']				- Delivery Address line 1
$basket['delInf']['add_2']				- Delivery Address line 1
$basket['delInf']['town']				- Delivery Town or city
$basket['delInf']['county']				- Delivery County or state
$basket['delInf']['postcode']			- Delivery Post/Zip Code
$basket['delInf']['country']			- Delivery  country Id we can look up the country name like this	
									countryName($basket['delInf']['country']);


$basket['subTotal'] 					- Order Subtotal (exTax and Shipping)
$basket['grandTotal']					- Basket total which has to be paid (inc Tax and Shipping).
$basket['tax']							- Total tax to pay
$basket['shipCost']						- Shipping price
////////////////////////////////////////////////////////
*/

$module = fetchDbConfig("GSPAY");

function repeatVars(){

		return FALSE;
	
}

function fixedVars(){
	
	global $module, $basket, $ccUserData, $cart_order_id, $config, $GLOBALS; 
	
	$amount = $basket['grandTotal'];

	// Trim $ sign if it exists
	if (substr($amount, 0,1) == "$") {
		$amount = substr($amount,1);
	}
	$loginid = $module['acNo'];
	$txnkey = $module['txnkey'];
	
	if(!empty($ccUserData[0]['add_2'])){

		$add = $ccUserData[0]['add_1'].", ".$ccUserData[0]['add_2'];
					
	} else {
						
		$add = $ccUserData[0]['add_1'];
					
	}
	
	srand(time());
	$sequence = rand(1, 1000);
	// Insert the form elements required for SIM by calling InsertFP		

	
	$hiddenVars = "
					<input type='hidden' name='siteID' value='".$loginid."' />
					<input type='hidden' name='orderAmount' value='".$amount."' />
					<input type='hidden' name='OrderID' value='".$cart_order_id."' />
					<input type='hidden' name='customerFullName' value='".$ccUserData[0]['firstName']." ".$ccUserData[0]['lastName']."' />
					<input type='hidden' name='returnUrl' value='".$GLOBALS['storeURL']."/modules/gateway/GSPAY/confirmed.php' />
					<input type='hidden' name='customerAddress' value='".$add."' />
					<input type='hidden' name='customerCity' value='".$ccUserData[0]['town']."' />
					<input type='hidden' name='customerStateCode' value='".$ccUserData[0]['county']."' />
					<input type='hidden' name='customerCountry' value='".countryName($basket['delInf']['country'])."' />
					<input type='hidden' name='customerZip' value='".$ccUserData[0]['postcode']."' />
					<input type='hidden' name='customerPhone' value='".$ccUserData[0]['phone']."' />
					<input type='hidden' name='customerEmail' value='".$ccUserData[0]['email']."' />
					<input type='hidden' name='customerShippingFullName' value='".$basket['delInf']['firstName']." ".$basket['delInf']['lastName']."' />
					<input type='hidden' name='customerShippingAddress' value='".$basket['delInf']['add_1']." ".$basket['delInf']['add_2']."' />
					<input type='hidden' name='customerShippingCity' value='".$basket['delInf']['town']."' />
					<input type='hidden' name='customerShippingStateCode' value='".$basket['delInf']['county']."' />
					<input type='hidden' name='customerShippingZip' value='".$basket['delInf']['postcode']."' />
					<input type='hidden' name='customerShippingPhone' value='".$ccUserData[0]['phone']."' />
					<input type='hidden' name='customerShippingCountry' value='".countryName($basket['delInf']['country'])."' />
					";
	foreach ($basket[invArray] as $key => $product) {
		$hiddenVars .= "<input type='hidden' name='Amount[$key]' value='".sprintf("%.02f",($product[price]/($product[quantity]>0 ? $product[quantity] : 1)))."'>\n";
		$hiddenVars .= "<input type='hidden' name='Qty[$key]' value='$product[quantity]'>\n";
		$hiddenVars .= "<input type='hidden' name='OrderDescription[$key]' value='$product[name]'>\n";
	}
	if ($basket[tax]>0) {
		$key++;
		$hiddenVars .= "<input type='hidden' name='Amount[$key]' value='$basket[tax]'>\n";
		$hiddenVars .= "<input type='hidden' name='Qty[$key]' value='1'>\n";
		$hiddenVars .= "<input type='hidden' name='OrderDescription[$key]' value='Tax'>\n";
	}
	if ($basket[shipCost]>0) {
		$key++;
		$hiddenVars .= "<input type='hidden' name='Amount[$key]' value='$basket[shipCost]'>\n";
		$hiddenVars .= "<input type='hidden' name='Type[$key]' value='Shipping'>\n";
		$hiddenVars .= "<input type='hidden' name='OrderDescription[$key]' value='$basket[shipMethod]'>\n";
	}

				
				if($module['testMode']==1){	
					//$hiddenVars .= "<input type='hidden' name='x_test_request' value='TRUE' />";
				}
			//	mydump($basket);

			//	mydump($hiddenVars);

				
			return $hiddenVars;
	
}
function mydump($mix, $screen=true, $file=true) {
    ob_start();
    print_r($mix);

    $text=(ob_get_contents());
    ob_end_clean();


    if ($screen) {
        $text=htmlentities($text);
        echo "<div align=left><pre>$text<br></pre></div>";
    }

}

///////////////////////////
// Other Vars
////////
if($module['testMode']==1){
$formAction = "https://secure.checkout2pay.com/payment/pay.php";
} else {
$formAction = "https://secure.checkout2pay.com/payment/pay.php";
}

$formMethod = "post";
$formTarget = "_self";
$transfer = "manual";
$stateUpdate = TRUE;
function success(){
		
		if($_GET['f']==1){
		
			return FALSE;
			
		} else {
		
			return TRUE;
			
		}	

}
?>
