<?php class Gspay_Redirect_Block_Success extends Mage_Core_Block_Template {
	protected function _toHtml() {
		$status=$this->gspay_check_order($_GET['x_trans_id']);

		$this->_order = Mage::getModel('sales/order')->loadByIncrementId($status['ORDERID']);
		$this->_paymentInst = $this->_order->getPayment()->getMethodInstance();

		if ($status['RESULTSTATUSCODE']==1) {
			if ($this->_paymentInst->getConfigData('auto_invoice')) {
				if ($this->_order->canInvoice()) {
					$invoice = $this->_order->prepareInvoice();
					$invoice->register()->capture();
					Mage::getModel('core/resource_transaction')->addObject($invoice)->save();
				}
			} $this->_order->addStatusToHistory($this->_paymentInst->getConfigData('second_order_status'), Mage::helper('redirect')->__($status['TRANSACTIONMESSAGE']), true);
			$this->_order->save();
			$this->_order->sendNewOrderEmail();
			$html = '<html><body> <script type="text/javascript"> window.location = "' . Mage::getUrl('checkout/onepage/success', array('_secure'=>true)) .'" </script> </body></html>';
			return $html;
		}


		$html = '<html><body> There was a problem processing your payment:<br /><br />' . $status['TRANSACTIONMESSAGE']. '<br /> <a href="' . Mage::getUrl('') . '">Click here</a> to return to ' . Mage::getStoreConfig('system/store/name') . '.' . '</body></html>';
		$this->_order->addStatusToHistory(Mage_Sales_Model_Order::STATE_CANCELED, Mage::helper('redirect')->__($status['ORDERID'].':'.$status['TRANSACTIONID'].':'.$status['TRANSACTIONMESSAGE']));
		$this->_order->save();
		return $html;
	}

	function gspay_check_order($transaction_id)
	{
		$url="https://secure.checkout2pay.com/payment/api.php";
		$values=array(
		                'request'=>"
		                          <xml>
		                          <request>
		                          <transaction>
		                          <transactionType>transactionStatus</transactionType>
		                          <transactionTransactionID>".$transaction_id."</transactionTransactionID>
		                          </transaction>


		                          </request>
		                          </xml>

		                          ",
		        );
		$params='';

		foreach ($values as $key=>$value) {
			$params.="$key=".urlencode($value)."&";
		}


		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $url);
		curl_setopt($ch, CURLOPT_POST, 1);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
		curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 180);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);

		curl_setopt($ch, CURLOPT_POSTFIELDS, $params);

		$result=curl_exec($ch);
		if (curl_errno($ch)>0) {
			exit("CURL ERROR:".curl_errno($ch).":".curl_error($ch));
		}
		curl_close($ch);


		$requestxml=$result;
		$p = xml_parser_create();
		if (!  xml_parse_into_struct($p, $requestxml, $vals, $index)) {
			exit("can't parse gspay result");
		}
		xml_parser_free($p);


		if (is_array($vals)) foreach ($vals as $key=>$value) {
			if ($value['type']=='complete') {
				$transinfo[$value['tag']]=trim($value['value']);
			}
		}
		return $transinfo;
	}

}
