<?php

if (!defined('_PS_VERSION_'))
	exit;

class Gspay extends PaymentModule
{	
	const LEFT_COLUMN = 0;
	const RIGHT_COLUMN = 1;
	const DISABLE = -1;

	public function __construct()
	{
		$this->name = 'gspay';
		$this->tab = 'payments_gateways';
		$this->version = '1.6';

		parent::__construct();

		$this->page = basename(__FILE__, '.php');
		$this->displayName = $this->l('Gspay');
		$this->description = $this->l('Accepts payments by Gspay.');
		$this->confirmUninstall = $this->l('Are you sure you want to delete your details ?');

		/* For 1.4.3 and less compatibility */
		$updateConfig = array('PS_OS_CHEQUE', 'PS_OS_PAYMENT', 'PS_OS_PREPARATION', 'PS_OS_SHIPPING', 'PS_OS_CANCELED', 'PS_OS_REFUND', 'PS_OS_ERROR', 'PS_OS_OUTOFSTOCK', 'PS_OS_BANKWIRE', 'PS_OS_PAYPAL', 'PS_OS_WS_PAYMENT');
		if (!Configuration::get('PS_OS_PAYMENT'))
			foreach ($updateConfig as $u)
				if (!Configuration::get($u) && defined('_'.$u.'_'))
					Configuration::updateValue($u, constant('_'.$u.'_'));

	}

	public function install()
	{
		if (!parent::install() OR 
			!$this->registerHook('payment') OR 
			!$this->registerHook('paymentReturn'))
			return false;
		Configuration::updateValue('GSPAY_SITE_ID', 0);
		Configuration::updateValue('GSPAY_MERCHANT_ID', 0);
		return true;
	}

	public function uninstall()
	{
		if (!parent::uninstall())
			return false;

		/* Clean configuration table */
		Configuration::deleteByName('GSPAY_SITE_ID');
		Configuration::deleteByName('GSPAY_MERCHANT_ID');
		return true;
	}

	/*
	** Fetch a distant content trying to use all the available function
	** if one of theme doesn't exist of failed
	*/
	private function _fetchWebContent($url, $timeout = 5, $contextOptions = array())
	{
		$stream_context = NULL;
		$defaultContextOptions = array(
				'http' => array(
       	'user_agent'			=> $_SERVER['HTTP_USER_AGENT'],
       	'max_redirects'		=> 10,
       	'timeout'       	=> $timeout,
       	'header'					=> array(
       		'Accept-language: en', 
          'Cookie: foo=bar')));
    
    if (is_callable('curl_init') && ($ch = curl_init()))
		{
			curl_setopt($ch, CURLOPT_URL, $url);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
			curl_setopt($ch, CURLOPT_HEADER, 0);
			curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, $timeout);
			
			$content = curl_exec($ch);
			curl_close($ch);
		}
		else
    {
    	// Check availability of the context options     
			if (!is_array($contextOptions) || !count($contextOptions))
				$contextOptions = $defaultContextOptions;
			
			// Create a stream context
			$stream_context = stream_context_create($contextOptions);
		
			if (($fp = @fopen($url, $mode, false, $stream_context)))
			{
				$content = fgets($fp, 4096);
				fclose($fp);
			}
			else if (!($content = @file_get_contents($url, false, $stream_context)))
				if (($fp = @fsockopen($url, 80, $errnom, $errstr, $timeout)))
					{
						preg_match('@^(?:http://)?([^/]+)@i', $url, $matches);  
						$host = $matches[1];
						$out = "GET / HTTP/1.1\r\n";
    				$out .= "Host: ".$host."\r\n";
    				$out .= "Connection: Close\r\n\r\n";

    				fwrite($fp, $out);
    				$fetched = '';
    				while (!feof($fp))
        			$fetched .= fgets($fp, 1024);
        		if (strlen($fetched))
        			$content = $fetched;
    				fclose($fp);
					}
		}
		if (!$content)
			throw new Exception($this->l('Unable to fetch content'));
		return $content;
	}
	public function getContent()
	{
		global $currentIndex, $cookie;
		
		if (Tools::isSubmit('submitGspayCheckout'))
		{
			$errors = array();
			if (($merchant_id = Tools::getValue('gspay_merchant_id')) AND preg_match('/^[0-9]+$/', $merchant_id))
				Configuration::updateValue('GSPAY_MERCHANT_ID', $merchant_id);
			else
				$errors[] = '<div class="warning warn"><h3>'.$this->l('Merchant ID seems to be wrong').'</h3></div>';


			if (($site_id= Tools::getValue('gspay_site_id')) AND preg_match('/^[0-9]+$/', $site_id))
				Configuration::updateValue('GSPAY_SITE_ID', $site_id);
			else
				$errors[] = '<div class="warning warn"><h3>'.$this->l('Site id seems to be wrong').'</h3></div>';

			if (!sizeof($errors))
				Tools::redirectAdmin($currentIndex.'&configure=gspay&token='.Tools::safeOutput(Tools::getValue('token')).'&conf=4');
			foreach ($errors as $error)
				echo $error;
		}
		
		$html = '<h2>'.$this->displayName.'</h2>
		<form action="'.Tools::safeOutput($_SERVER['REQUEST_URI']).'" method="post">
			<fieldset>
			<legend><img src="'.__PS_BASE_URI__.'modules/gspay/logo.gif" />'.$this->l('Settings').'</legend>
			<p>
				<div class="warn">
				</div>
			</p>
				<p>
				</p>
				<label>
					'.$this->l('Currency').'
				</label>
				'.$this->l('Don\'t forget to specify the currency used in the Payment tabs under the currency section').'
				'.$this->getCurrency()->iso_code.'
				<p>
				<label>
					'.$this->l('GSPAY Site ID').'
				</label>
				<div class="margin-form">
					<input type="text" name="gspay_site_id" value="'.Tools::safeOutput(Tools::getValue('gspay_site_id', Configuration::get('GSPAY_SITE_ID'))).'" />
				</div>
				<label>
					'.$this->l('GSPAY Merchant ID').'
				</label>
				<div class="margin-form">
					<input type="text" name="gspay_merchant_id" value="'.Tools::safeOutput(Tools::getValue('gspay_merchant_id', Configuration::get('GSPAY_MERCHANT_ID'))).'" />
				</div>
				<div class="clear center"><input type="submit" name="submitGspayCheckout" class="button" value="'.$this->l('   Save   ').'" /></div>
			</fieldset>
		</form>
		<br /><br />
		';
		
		return $html;
	}

	
	private function _displayLogoBlock($position)
	{
		$imgPath = 'http://www.prestashop.com/images/logo_partners/logo-skrill.png';
		if (!@file_get_contents($imgPath))
			$imgPath = __PS_BASE_URI__.'modules/gspay/logo-skrill.png';
		return '<div style="text-align:center;"><img src="'.$imgPath.'" width=150 /></div>';
	}
	
	public function hookRightColumn($params)
	{
		return $this->_displayLogoBlock(self::RIGHT_COLUMN);
	}

	public function hookLeftColumn($params)
	{
		return $this->_displayLogoBlock(self::LEFT_COLUMN);
	}


	public function hookPayment($params)
	{
		global $smarty, $cookie;
		
		if (!Configuration::get('GSPAY_SITE_ID') OR !Configuration::get('GSPAY_MERCHANT_ID'))
			return;

		$flag = false;
		$allowedCurrencies = $this->getCurrency((int)$params['cart']->id_currency);
		foreach ($allowedCurrencies AS $allowedCurrency)
			if ($allowedCurrency['id_currency'] == $params['cart']->id_currency)
			{
				$flag = true;
				break;
			}

		if (!$flag)
		{
			/* Uncomment the line below if you'd like to display an error message, rather than not showing the Gspay module */
			// return $this->display(__FILE__, 'gspay-currency-error.tpl');
		}
		else
		{
			

			/* Load objects */
			$address = new Address((int)($params['cart']->id_address_delivery));
			$countryObj = new Country((int)($address->id_country), Configuration::get('PS_LANG_DEFAULT'));
			$state = new State((int)($address->id_state));
			$customer = new Customer((int)($params['cart']->id_customer));
			$currency = new Currency((int)($params['cart']->id_currency));
			$lang = new Language((int)($cookie->id_lang));

			$cart=$params['cart'];
			foreach ($cart->getProducts() as $p) {
				$productlisting.=sprintf("%s: qty:%d amount:%.02f %s\n",
							$p['name'],
							$p['cart_quantity'],
							$p['total'],
							$currency->iso_code
							);
			}


			$mbParams = array();

			/* About the merchant */
			$mbParams['pay_to_email'] = Configuration::get('GSPAY_SITE_ID');
			$mbParams['recipient_description'] = Configuration::get('PS_SHOP_NAME');
			$mbParams['hide_login'] = (int)(Configuration::get('GSP_HIDE_LOGIN'));
			$mbParams['id_logo'] = (int)(Configuration::get('GSP_ID_LOGO'));
			$mbParams['return_url'] = (Configuration::get('PS_SSL_ENABLED') ? 'https' : 'http').'://'.$_SERVER['HTTP_HOST'].__PS_BASE_URI__.'order-confirmation.php?id_cart='.(int)($params['cart']->id).'&id_module='.(int)($this->id).'&key='.$customer->secure_key;
			$mbParams['cancel_url'] = Configuration::get('GSP_CANCEL_URL');

			/* About the customer */
			$mbParams['pay_from_email'] = $customer->email;
			$mbParams['firstname'] = $address->firstname;
			$mbParams['lastname'] = $address->lastname;
			$mbParams['address'] = $address->address1;
			$mbParams['address2'] = $address->address2;
			$mbParams['phone_number'] = !empty($address->phone_mobile) ? $address->phone_mobile : $address->phone;
			$mbParams['postal_code'] = $address->postcode;
			$mbParams['city'] = $address->city;
			$mbParams['state'] = $address->id_state ? $state->iso_code : 'XX';
			$mbParams['country'] = $countryObj->iso_code;
			$mbParams['language'] = strtoupper($lang->iso_code);
			$mbParams['date_of_birth'] = substr($customer->birthday, 5, 2).substr($customer->birthday, 8, 2).substr($customer->birthday, 0, 4);

			/* About the cart */
			$mbParams['transaction_id'] = (int)($params['cart']->id).'_'.date('YmdHis').'_'.$params['cart']->secure_key;
			$mbParams['currency'] = $currency->iso_code;
			$mbParams['amount'] = number_format($params['cart']->getOrderTotal(), 2, '.', '');
			$mbParams['amount2'] = $mbParams['amount'];
			$mbParams['amount2_description'] = $productlisting;

			/* URLs */
			$mbParams['status_url'] = (Configuration::get('PS_SSL_ENABLED') ? 'https' : 'http').'://'.$_SERVER['HTTP_HOST'].__PS_BASE_URI__.'modules/'.$this->name.'/validation.php';

			/* Assign settings to Smarty template */
			$smarty->assign($mbParams);

			/* Display the Gspay iframe */
			return $this->display(__FILE__, 'gspay.tpl');
		}
	}

	public function hookPaymentReturn($params)
	{
		if (!$this->active)
			return ;

		global $smarty;

		switch($params['objOrder']->getCurrentState())
		{
			case _PS_OS_PAYMENT_:
			case _PS_OS_OUTOFSTOCK_:
				$smarty->assign('status', 'ok');
				break;
				
			case _PS_OS_BANKWIRE_:
				$smarty->assign('status', 'pending');
				break;
				
			case _PS_OS_ERROR_:
			default:
				$smarty->assign('status', 'failed');
				break;
		}

		return $this->display(__FILE__, 'confirmation.tpl');
	}
}


