<?php

class Mage_Gspay_Block_Standard_Redirect extends Mage_Core_Block_Abstract
{
    protected function _toHtml()
    {
        $standard = Mage::getModel('Gspay/standard');
        
        $timestamp = strftime("%Y%m%d%H%M%S");

        $form = new Varien_Data_Form();
        $form->setAction($standard->getGspayUrl())
            ->setId('Gspay_standard_checkout')
            ->setName('Gspay_standard_checkout')
            ->setMethod('POST')
            ->setUseContainer(true);
            
           
        $currency = $standard->getQuote()->getBaseCurrencyCode();
        $orderid = $standard->getCheckout()->getLastRealOrderId();
		
		$amount = 0;
		
		if($standard->getConfigData('currency') == 'display'){
	        $currency = $standard->getQuote()->getStore()->getCurrentCurrency();
            $amount = $standard->getQuote()->getGrandTotal();
		}else{
			$currency = $standard->getQuote()->getBaseCurrencyCode();
			$amount = $standard->getQuote()->getBaseGrandTotal();
		}

		$amount=sprintf("%.02f",$amount);
		/*	
		$amount = $amount * 100;
		$amount = round($amount);
		*/
        
        $merchantid = $standard->getConfigData('login');
        $secret = $standard->getConfigData('pwd');
        
        //Mage::log($standard->getQuote()->getCcType());
        //Mage::log($standard->getQuote()->getPayment()->getCcType());
        if($standard->getQuote()->getPayment()->getCcType() == 'amex'){
        	$account = $standard->getConfigData('amexAccount');
        }else{
        	$account = $standard->getConfigData('account');
        }
        
        $tmp = "$timestamp.$merchantid.$orderid.$amount.$currency";
        $sha1hash = sha1($tmp);
		$tmp = "$sha1hash.$secret";
		$sha1hash = sha1($tmp);
		
		if($standard->getConfigData('payment_action') == 'authorize'){
			$autosettle = 0;
		}else{
			$autosettle = 1;	
		}

		$customerID = $standard->getQuote()->getCustomerId();

		$billing = $standard->getQuote()->getBillingAddress();
		$billingCountry = $billing->getCountry();
		$billingPostcode = $billing->getPostcode();
		
		$shipping = $standard->getQuote()->getShippingAddress();
		$shippingCountry = $shipping->getCountry();
		$shippingPostcode = $shipping->getPostcode();	

		$customer=$standard->getQuote()->getCustomer();
		//echo "<pre>"; var_dump(get_class_methods($standard->getQuote())); echo "</pre>";
		$items=$standard->getQuote()->getAllVisibleItems();
		//echo "<pre>"; var_dump(get_class_methods($addresses)); echo "</pre>";
		//echo "<pre>"; var_dump(($addresses->getGroupedAllShippingRates())); echo "</pre>";
		$itemsTxt='';
		$itemsAmount=0;
		$j=0;
		foreach ($items as $i) {
			$d=$i->getData();
			$itemsTxt.=sprintf("%s, qty:%d, amount:%.2f<br>\n",$d['name'],$d['qty'],$d['row_total']);
			$itemsAmount+=$d['row_total'];
			$form->addField("OrderDescription[$j]", 'hidden', array('name'=>"OrderDescription[$j]", 'value'=>$d['name']));
			$form->addField("Qty[$j]", 'hidden', array('name'=>"Qty[$j]", 'value'=>$d['qty']));
			$form->addField("Amount[$j]", 'hidden', array('name'=>"Amount[$j]", 'value'=>$d['price']));
			$j++;
		}
		if (abs($itemsAmount-$amount)>.01) {
			$itemsTxt.=sprintf("Shipping and handling fees:%.2f<br>\n",$amount-$itemsAmount);
			$form->addField("OrderDescription[$j]", 'hidden', array('name'=>"OrderDescription[$j]", 'value'=>'Shipping and handling fees'));
			$form->addField("Amount[$j]", 'hidden', array('name'=>"Amount[$j]", 'value'=>$amount-$itemsAmount));
			$j++;
		}
		/*
		echo "<pre>"; var_dump($billing); echo "</pre>";
		echo "<pre>"; var_dump($customer); echo "</pre>";
		*/
		$host=parse_url($_SERVER['HTTP_REFERER']);
		$returnUrl=sprintf("%s://%s%s",$host['scheme'],$host['host'].(isset($host['port'])?":".$host['port']:''),str_replace('/redirect/','/success/',$_SERVER['REQUEST_URI']));


        
        $form->addField('siteID', 'hidden', array('name'=>'siteID', 'value'=>$merchantid));
        $form->addField('returnUrl', 'hidden', array('name'=>'returnUrl', 'value'=>$returnUrl));
        $form->addField('OrderID', 'hidden', array('name'=>'OrderID', 'value'=>$orderid));
//        $form->addField('OrderDescription', 'hidden', array('name'=>'OrderDescription', 'value'=>$itemsTxt));
//        $form->addField('Amount', 'hidden', array('name'=>'Amount', 'value'=>$amount));

        $form->addField('customerFullName', 'hidden', array('name'=>'customerFullName', 'value'=>$billing->getName()));
        $form->addField('customerPhone', 'hidden', array('name'=>'customerPhone', 'value'=>$billing->getTelephone()));
        $form->addField('customerAddress', 'hidden', array('name'=>'customerAddress', 'value'=>$billing->getStreetFull()));
        $form->addField('customerCity', 'hidden', array('name'=>'customerCity', 'value'=>$billing->getCity()));
        $form->addField('customerState', 'hidden', array('name'=>'customerState', 'value'=>trim($billing->getRegion()) ));
        $form->addField('customerZip', 'hidden', array('name'=>'customerZip', 'value'=>$billing->getPostcode()));
        $form->addField('customerCountryCode', 'hidden', array('name'=>'customerCountryCode', 'value'=>$billing->getCountry()));
        $form->addField('customerEmail', 'hidden', array('name'=>'customerEmail', 'value'=>$billing->getEmail()));
        $html = '<html><body>';
        $html.= $this->__('You will be redirected to Gspay in a few seconds.');
        $html.= $form->toHtml();
        $html.= '<script type="text/javascript">document.getElementById("Gspay_standard_checkout").submit();</script>';
	/*
$html.="
<pre>
".htmlentities($form->toHtml())."
</pre>
";
*/
        $html.= '</body></html>';
        
        //if($standard->getConfigData('debug')){
	        Mage::log($html);
        //}

        return $html;
    }
}
