<?php

    /**
      * Class that implements Payment Module for Gspay
      */
class Mage_Gspay_Model_Remote extends Mage_Payment_Model_Method_Ccsave{
   
	const REQUEST_TYPE_AUTH_CAPTURE = 'AUTH_CAPTURE';
    const REQUEST_TYPE_AUTH_ONLY    = 'AUTH_ONLY';
    const REQUEST_TYPE_CAPTURE_ONLY = 'CAPTURE_ONLY';
    const REQUEST_TYPE_CREDIT       = 'CREDIT';
    const REQUEST_TYPE_VOID         = 'VOID';
    
    protected $_code = 'gspay';
    protected $_formBlockType = 'Gspay/remote_form';

    protected $_isGateway = true;
    protected $_canAuthorize = true;
    protected $_canCapture = true;
    protected $_canCapturePartial = true;
    protected $_canRefund = true;
    protected $_canVoid = true;
    protected $_canUseInternal = true;
    protected $_canUseCheckout = true;
    protected $_canUseForMultishipping  = true;
    protected $_canSaveCc = false;

    protected $parentElements = array();
    protected $TSSChecks = array();
    protected $currentElement = 0;
    protected $currentTSSCheck = "";
    
     /**
     * Assign data to info model instance
     *
     * @param   mixed $data
     * @return  Mage_Payment_Model_Info
     */
    public function assignData($data)
    {

        if (!($data instanceof Varien_Object)) {
            $data = new Varien_Object($data);
        }
        $info = $this->getInfoInstance();
        $info->setCcType($data->getCcType())
            ->setCcOwner($data->getCcOwner())
            ->setCcLast4(substr($data->getCcNumber(), -4))
            ->setCcNumber($data->getCcNumber())
            ->setCcCid($data->getCcCid())
            ->setCcExpMonth($data->getCcExpMonth())
            ->setCcExpYear($data->getCcExpYear())
            // For Switch/Solo cards
            ->setCcSsIssue($data->getCcSsIssue())
            ->setCcSsStartMonth($data->getCcSsStartMonth())
            ->setCcSsStartYear($data->getCcSsStartYear());
        return $this;
    }
    
    public function createFormBlock($name)
    {
        $block = $this->getLayout()->createBlock('Gspay/remote_form', $name)
            ->setMethod('Gspay_Remote')
            ->setPayment($this->getPayment())
            ->setTemplate('Gspay/remote/form.phtml');

        return $block;
    }

    
    public function OtherCcType($type){

        return $type=='OT' || $type=='LA';
    }
      
    public function authorize(Varien_Object $payment, $amount){
	$error = false;

	$url = "https://epage.payandshop.com/epage-remote.cgi";
	$transactiontype = 'auth';
	
    if($amount > 0){
	
	    $request = $this->_buildRequest($payment, $amount, 0);
	    $response = $this->_postRequest($request, $url);
	    $this->parseXML($response);

	    
        global $RESPONSE_AUTHCODE;
        global $RESPONSE_ORDERID;
        global $RESPONSE_PASREF;
        
	    global $RESPONSE_RESULT;
	    global $RESPONSE_MESSAGE;
	        
        $payment->setCcApproval($RESPONSE_AUTHCODE)
	        ->setLastTransId($RESPONSE_ORDERID)
            ->setCcTransId($RESPONSE_ORDERID)
            ->setCcAvsStatus($RESPONSE_PASREF);
                
         global $RESPONSE_RESULT;
         if($RESPONSE_RESULT == "00"){
          	$result = "APPROVED";                
         }else if(substr($RESPONSE_RESULT,0,1) == '1'){
         	$result = "DECLINED";
         }else {
          	$result = "ERROR";
         }
            
         switch ($result) {
         	case self::STATUS_APPROVED:
            	$payment->setStatus(self::STATUS_APPROVED);
                break;
            default:
                $error = Mage::helper('paygate')->__('Payment authorization error. ' . $RESPONSE_RESULT . ' : ' . $RESPONSE_MESSAGE);
                break;
          }
		}else{
              $error = Mage::helper('paygate')->__('Invalid amount for authorization.');
        }
        
		if ($error !== false) {
            Mage::throwException($error);
        }
        
        return $this;
    }
    
    public function capture(Varien_Object $payment, $amount){
		$error = false;
		
		$url = "https://epage.payandshop.com/epage-remote.cgi";
	
		if($amount > 0){
			
		if ($payment->getLastTransId()) {
			$request = $this->_buildSettleRequest($payment);
		}else{
			$request = $this->_buildRequest($payment, $amount, 1);
		}
	    $response = $this->_postRequest($request, $url);
	   	$this->parseXML($response);
	    
        global $RESPONSE_AUTHCODE;
        global $RESPONSE_ORDERID;
        global $RESPONSE_PASREF;
        
	    global $RESPONSE_RESULT;
	    global $RESPONSE_MESSAGE;            
           
        $payment->setCcApproval($RESPONSE_AUTHCODE)
	        ->setLastTransId($RESPONSE_ORDERID)
            ->setCcTransId($RESPONSE_ORDERID)
            ->setCcAvsStatus($RESPONSE_PASREF);
                            
         global $RESPONSE_RESULT;
         if($RESPONSE_RESULT == "00"){
          	$result = "APPROVED";                
         }else if(substr($RESPONSE_RESULT,0,1) == '1'){
         	$result = "DECLINED";
         }else {
          	$result = "ERROR";
         }
            
         switch ($result) {
         	case self::STATUS_APPROVED:
            	$payment->setStatus(self::STATUS_APPROVED);
                break;
            default:
                $error = Mage::helper('paygate')->__('Payment authorization error. ' . $RESPONSE_RESULT . ' : ' . $RESPONSE_MESSAGE);
                break;
          }
		}else{
              $error = Mage::helper('paygate')->__('Invalid amount for authorization.');
        }

		if ($error !== false) {
            Mage::throwException($error);
        }
        
        return $this;
    }
    
    public function void(Varien_Object $payment){
    	Mage::log("void");
    	Mage::throwException("void");	
    }
     
    public function refund(Varien_Object $payment, $amount){
       	Mage::log("refund");
    	Mage::throwException("refund");	
    }
    
    protected function _buildRequest(Varien_Object $payment, $amount, $autosettle){
	
		//Get data from Magento Admin Backend for Gspay Payment Module    
		$merchantid = $this->getConfigData('login');
		$secret = $this->getConfigData('pwd');
		$account = $this->getConfigData('account');
	
		//Get information from order and set the appropriate variables.
	    $order = $payment->getOrder();
        $billing = $order->getBillingAddress();

		if($this->getConfigData('currency') == 'display'){
	        $currency = $order->getOrderCurrencyCode();
            $amount = $order->getTotalDue();
		}else{
			$currency = $order->getBaseCurrencyCode();	
		}
		
		/* multiplied by 100 because Gspay deals in cents as the base unit
         * while magento uses euro
         */
        $amount = $amount * 100;
        // If in Test Mode use dummy Credit Card values.
		if($this->getConfigData('test')){
		    $cardnumber = "4263971921001307";
	    	$cardname = "John Smith";
		    $cvc = "666";
		    $expdate = "0612";
	    	$cardtype = "visa";
		}else{
		    $cardnumber = $payment->getCcNumber();
        	$cardname = $order->getCustomerName();
		    $cvc = $payment->getCcCid();
	    
   		    $cardtype = $this->convertCcType($payment->getCcType());
   		    if($cardtype == 'amex'){
   		    	$account = $this->getConfigData('amexAccount');
   		    }
   		    
	    	/* Converts expiry date stored by Magento to a two-digit month and two digit
		     * year format without a seperator such as a hyphen.
		     */
	    	$expdate = sprintf('%02d%02d', $payment->getCcExpMonth(), substr($payment->getCcExpYear(), 2));
	    
		    $issueno = $payment->getCcSsIssue();
		}
        
        // The Timestamp is created here and used in the digital signature
        $timestamp = strftime("%Y%m%d%H%M%S");
        mt_srand((double)microtime()*1000000);

        $orderid = $order->getIncrementId();

        /* This section of code creates the md5hash that is needed
        $tmp = "$timestamp.$merchantid.$orderid.$amount.$currency.$cardnumber";
        $md5hash = md5($tmp);
        $tmp = "$md5hash.$secret";
        $md5hash = md5($tmp);
		*/
		
		// This section of code creates the shahash that is needed
        $tmp = "$timestamp.$merchantid.$orderid.$amount.$currency.$cardnumber";
        $sha1hash = sha1($tmp);
        $tmp = "$sha1hash.$secret";
        $sha1hash = sha1($tmp);
		
		$customerID = $order->getCustomerId();
	
		//If there's only one product being bought, add it into the XML.
		$products = array();
        foreach ($order->getItemsCollection() as $item) {
            $products[] = $item->getProductId();
        }
		
		$productID;
		if(!(count($products)>1)){
	    	$productID = $products[0];
		}
	
		$billingCountry = $billing->getCountry();
		$billingPostcode = $billing->getPostcode();
		
		$shipping = $order->getShippingAddress();
		$shippingCountry = $shipping->getCountry();
		$shippingPostcode = $shipping->getPostcode();	
    
        //Use the variables set above to fill in the request xml that is sent to Gspay Payments.
        $xml = "<request timestamp='$timestamp' type='auth' >
                        <merchantid>$merchantid</merchantid>
						<account>$account</account>
                        <orderid>$orderid</orderid>
                        <amount currency='$currency'>$amount</amount>
                        <card> 
                            <number>$cardnumber</number>
                            <expdate>$expdate</expdate>
                            <chname>$cardname</chname> 
                            <type>$cardtype</type> 
                            <issueno>$issueno</issueno>
                        </card>
                        <cvn>
                            <number>$cvc</number>
                            <presind>1</presind>
                        </cvn>
                        <autosettle flag='$autosettle'/>
						<tssinfo>
						    <custnum>$customerID</custnum>
				    		<prodid>$productID</prodid>
					    	<address type='billing'> 
								<code>$billingPostcode</code>  
								<country>$billingCountry</country>  
						    </address> 
						    <address type='shipping'> 
								<code>$shippingPostcode</code>  
								<country>$shippingCountry</country>  
						    </address>
						</tssinfo>
                        <sha1hash>$sha1hash</sha1hash>
					</request>";
		    
	    //Prints request xml to /var/log/system.log if in Debug mode
	    if($this->getConfigData('debug')){
			Mage::log($xml);
	    }
	    return $xml;
    }
    
    protected function _buildSettleRequest($payment){
    	// The Timestamp is created here and used in the digital signature
        $timestamp = strftime("%Y%m%d%H%M%S");
        mt_srand((double)microtime()*1000000);
        
        $merchantid = $this->getConfigData('login');
		$secret = $this->getConfigData('pwd');
		$account = $this->getConfigData('account');
				
		$orderid = $payment->getCcTransId();
    	
    	// This section of code creates the shahash that is needed
        $tmp = "$timestamp.$merchantid.$orderid...";
        $sha1hash = sha1($tmp);
        $tmp = "$sha1hash.$secret";
        $sha1hash = sha1($tmp);
        
        $pasref = $payment->getCcAvsStatus();
        $authcode = $payment->getCcApproval();
            	
    	$xml = "<request timestamp='$timestamp' type='settle'> 
					<merchantid>$merchantid</merchantid>  
					<account>$account</account>  
					<orderid>$orderid</orderid>  
					<pasref>$pasref</pasref>  
					<authcode>$authcode</authcode>
					<sha1hash>$sha1hash</sha1hash>  
				</request>";
	  
	    //Prints request xml to /var/log/system.log if in Debug mode
	    if($this->getConfigData('debug')){
			Mage::log($xml);
	    }

    	return $xml;
    }
    
    protected function _postRequest($request, $url){
		$client = new Varien_Http_Client($url);
    	$client->resetParameters(); 
		$client->setMethod('POST');
		$client->setRawData($request, 'text/xml');
	    $response = $client->request('POST');
	    
        $response = $response->getBody();
        
        //Prints request xml to /var/log/system.log if in Debug mode
		if($this->getConfigData('debug')){
	    	Mage::log($response);
		}
                      
        // Tidy it up
        $response = eregi_replace ( "[[:space:]]+", " ", $response );
        $response = eregi_replace ( "[\n\r]", "", $response );
	
		return $response;
    }
    
    function parseXML($response){
  		// Create and initialise XML parser
        $xml_parser = xml_parser_create();
        xml_set_element_handler($xml_parser, Array(&$this, "startElement"), Array(&$this, "endElement")); 
        xml_set_character_data_handler($xml_parser, Array(&$this, "cDataHandler"));
               
        // Parse the response xml
        if (!xml_parse($xml_parser, $response)) {
        	die(sprintf("XML error: %s at line %d",
            xml_error_string(xml_get_error_code($xml_parser)),
            xml_get_current_line_number($xml_parser)));
        }
            
        // garbage collect the parser.
        xml_parser_free($xml_parser);
     }


    /*
     The "startElement()" function is called when an open element tag is found.
     It creates a variable on the fly contructed of all the parent elements
     joined together with an underscore. So the following xml:

     <response><something>Owen</something></response>

     would create two variables:
     $RESPONSE and $RESPONSE_SOMETHING
    */
    function startElement($parser, $name, $attrs) {
        //global $parentElements;
        global $currentElement;
        global $currentTSSCheck;
	
		array_push($this->parentElements, $name);
		$currentElement = join("_", $this->parentElements);

		foreach ($attrs as $attr => $value) {
			if ($currentElement == "RESPONSE_TSS_CHECK" and $attr == "ID") {
				$currentTSSCheck = $value;
			}

			$attributeName = $currentElement."_".$attr;

			global $$attributeName;
			$$attributeName = $value;
		}
    }

    /* The "cDataHandler()" function is called when the parser encounters any text that's 
       not an element. Simply places the text found in the variable that 
       was last created. So using the XML example above the text "Owen"
       would be placed in the variable $RESPONSE_SOMETHING
    */
    function cDataHandler($parser, $cdata) {
        global $currentElement;
		global $currentTSSCheck;
		global $TSSChecks;

		if ( trim ( $cdata ) ) { 
			if ($currentTSSCheck != 0) {
				$TSSChecks["$currentTSSCheck"] = $cdata;
			}

            global $$currentElement;
			$$currentElement .= $cdata;
		}
	}

    // The "endElement()" function is called when the closing tag of an element is found. 
    // Just remove that element from the array of parent elements.
    function endElement($parser, $name) {
		global $currentTSSCheck;
		$currentTSSCheck = 0;
		array_pop($this->parentElements);
    }
    
    /* The abbreviations that Gspay uses for credit card types are different
   	* in most cases to those used by Magento. So here we do the conversion.
    * It might make more sense to do this elsewhere.
    */
    protected function convertCcType($type){
		$cardtype = "";
		if($type == 'VI'){
    	    $cardtype = "visa";
	    }else if($type == 'MC'){
	        $cardtype = "mc";
    	}else if($type == 'AE'){
        	$cardtype = "amex";
		}else if($type == 'SS'){
	    	$cardtype = "switch";
		}else if($type == 'LA'){
			$cardtype = "laser";
		}else if($type == 'DI'){
			$cardtype = "diners";
		}else{
		   	Mage::throwException("Incorrect Currency Code!");
		   	return $cardtype;
		}
		return $cardtype;
    }
}
      
?>