<?php

class Mage_Gspay_Model_Standard extends Mage_Payment_Model_Method_Abstract{
    //changing the payment to different from cc payment type and Gspay payment type
    const PAYMENT_TYPE_AUTH = 'AUTHORIZATION';
    const PAYMENT_TYPE_SALE = 'SALE';

    protected $_code  = 'gspay';
    protected $_formBlockType = 'Gspay/standard_form';
    protected $_allowCurrencyCode = array('AUD', 'CAD', 'CHF', 'CZK', 'DKK', 'EUR', 'GBP', 'HKD', 'HUF', 'JPY', 'NOK', 'NZD', 'PLN', 'SEK', 'SGD','USD');


 	public function assignData($data)
    {
        if (!($data instanceof Varien_Object)) {
            $data = new Varien_Object($data);
        }
        $info = $this->getInfoInstance();
        $info->setCcType($data->getAmex());
                
        return $this;
    }

     /**
     * Get Gspay session namespace
     *
     * @return Mage_Gspay_Model_Session
     */
    public function getSession()
    {
        return Mage::getSingleton('Gspay/session');
    }
    

    /**
     * Get checkout session namespace
     *
     * @return Mage_Checkout_Model_Session
     */
    public function getCheckout()
    {
        return Mage::getSingleton('checkout/session');
    }

    /**
     * Get current quote
     *
     * @return Mage_Sales_Model_Quote
     */
    public function getQuote()
    {
        return $this->getCheckout()->getQuote();
    }

    /**
     * Using internal pages for input payment data
     *
     * @return bool
     */
    public function canUseInternal()
    {
        return false;
    }

    /**
     * Using for multiple shipping address
     *
     * @return bool
     */
    public function canUseForMultishipping()
    {
        return false;
    }

    public function createFormBlock($name)
    {
        $block = $this->getLayout()->createBlock('Gspay/standard_form', $name)
            ->setMethod('Gspay_standard')
            ->setPayment($this->getPayment())
            ->setTemplate('Gspay/standard/form.phtml');

        return $block;
    }

    /*validate the currency code is avaialable to use for Gspay or not*/
    public function validate()
    {
        parent::validate();
        $currency_code = $this->getQuote()->getBaseCurrencyCode();
        if (!in_array($currency_code,$this->_allowCurrencyCode)) {
            Mage::throwException(Mage::helper('Gspay')->__('Selected currency code ('.$currency_code.') is not compatabile with Gspay'));
        }
        return $this;
    }

    public function onOrderValidate(Mage_Sales_Model_Order_Payment $payment)
    {
       return $this;
    }

    public function onInvoiceCreate(Mage_Sales_Model_Invoice_Payment $payment)
    {

    }

    public function canCapture()
    {
        return true;
    }

    public function getOrderPlaceRedirectUrl()
    {
          return Mage::getUrl('Gspay/standard/redirect', array('_secure' => true));
    }
    
    public function getSuccessUrl(){
    	return Mage::getUrl('Gspay/standard/success');
    }
    
    public function getCancelUrl(){
    	return Mage::getUrl('Gspay/standard/cancel');
    }

    public function getGspayUrl(){
		$url = "https://secure.checkout2pay.com/payment/pay.php";
        return $url;
    }
    
    public function getDebug()
    {
        return Mage::getStoreConfig('Gspay/wps/debug_flag');
    }

    public function isInitializeNeeded()
    {
        return true;
    }

    public function initialize($paymentAction, $stateObject)
    {
        //$state = Mage_Sales_Model_Order::STATE_PENDING_PAYMENT;
        $state = "Gspay Processing";
        $stateObject->setState($state);
        //$stateObject->setStatus(Mage::getSingleton('sales/order_config')->getStateDefaultStatus($state));
        $stateObject->setIsNotified(false);
    }
}

?>
