<?php
/*
function mydump($data) {
    echo "<pre>";
    echo htmlentities(print_r($data,1));
    echo "</pre>";
}
*/

class Mage_Gspay_StandardController extends Mage_Core_Controller_Front_Action
{
    /**
     * Order instance
     */
    protected $_order;
    
    /**
     *  Get order
     *
     *  @param    none
     *  @return	  Mage_Sales_Model_Order
     */
    public function getOrder()
    {
        if ($this->_order == null) {
        }
        return $this->_order;
    }

    protected function _expireAjax()
    {
        if (!Mage::getSingleton('checkout/session')->getQuote()->hasItems()) {
            $this->getResponse()->setHeader('HTTP/1.1','403 Session Expired');
            exit;
        }
    }

    /**
     * Get singleton with Gspay Standard order transaction information
     *
     * @return Mage_Gspay_Model_Standard
     */
    public function getStandard()
    {
        return Mage::getSingleton('Gspay/standard');
    }

    /**
     * When a customer chooses Gspay on Checkout/Payment page
     *
     */
    public function redirectAction()
    {
    	$session = Mage::getSingleton('checkout/session');
        $session->setGspayStandardQuoteId($session->getQuoteId());
        
        //original way of doing it
        //$this->getResponse()->setBody($this->getLayout()->createBlock('Gspay/standard_redirect')->toHtml());
        //$session->unsQuoteId();
        
        //epay way of doing it - prettier
        $this->loadLayout();
        $this->getLayout()->getBlock('content')->append($this->getLayout()->createBlock('Gspay/standard_redirect'));
        $this->renderLayout();

    }

    /**
     * When a customer cancel payment from Gspay.
     */
    public function cancelAction()
    {
        $session = Mage::getSingleton('checkout/session');
        $session->setQuoteId($session->getGspaystandardQuoteId(true));

        // cancel order
        if ($session->getLastRealOrderId()) {
            $order = Mage::getModel('sales/order')->loadByIncrementId($session->getLastRealOrderId());
            if ($order->getId()) {
                $order->cancel()->save();
            }
        }

        $this->_redirect('checkout/cart');
    }

    /**
     * when Gspay returns
     */
    public function  successAction()
    {
    	$order = Mage::getModel('sales/order');
//	echo "<pre>";var_dump($_POST);echo "</pre>";
//	echo "<pre>";var_dump($_GET);echo "</pre>";
//	echo "<pre>";var_dump($_SESSION);echo "</pre>";
//	echo "<pre>";var_dump($order);echo "</pre>";
//	exit();
    	    	
        if($_GET){
        	if (isset($_GET['customerOrderID'])) {
		    	$thisorder = $order->loadByIncrementId($_GET['customerOrderID']);

			//========================================================
    $url="https://secure.checkout2pay.com/payment/api.php";
        $values=array(
        'request'=>"
                <xml>
                <request>
                <transaction>
                        <transactionType>transactionStatus</transactionType>
                        <transactionTransactionID>".$_GET['transactionTransactionID']."</transactionTransactionID>
                </transaction>

                
                </request>
                </xml>
        
        ",
        );
	$params='';
        foreach ($values as $key=>$value) {
                $params.="$key=".urlencode($value)."&";
        }


        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 180);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $params);
        $result=curl_exec($ch);


        $requestxml=$result;
        $p = xml_parser_create();
        if (!  xml_parse_into_struct($p, $requestxml, $vals, $index)) {
	    $this->_redirect('checkout/cart');
        }
        xml_parser_free($p);


        if (is_array($vals)) foreach ($vals as $key=>$value) {
                if ($value['type']=='complete') {
                        $transinfo[$value['tag']]=trim($value['value']);
                }
        }


        if (!(($transinfo['TRANSACTIONSTATUS']=='approved' || $transinfo['TRANSACTIONSTATUS']=='test' ) && $transinfo['TRANSACTIONTYPE']=='sale')) {
		$thisorder->setState(Mage_Sales_Model_Order::STATE_COMPLETE,$transinfo['TRANSACTIONSTATUS'],$transinfo['TRANSACTIONMESSAGE'],true);
        } else {
		$thisorder->setState(Mage_Sales_Model_Order::STATE_CLOSED,$transinfo['TRANSACTIONSTATUS'],$transinfo['TRANSACTIONMESSAGE'],true);
	}
	$thisorder->save();
			//========================================================



   				$thisorder->sendNewOrderEmail();	
   				$session = Mage::getSingleton('checkout/session');
	    	    $session->setQuoteId($_GET['customerOrderID']);			
		    }
       	 
   	        $this->getResponse()->setBody($this->getLayout()->createBlock('Gspay/Standard_response')->toHtml());
		
        }else{	        
        	//set the quote as inactive after back from Gspay
	       //Mage::getSingleton('checkout/session')->getQuote()->setIsActive(false)->save();
    	    $this->_redirect('checkout/onepage/success', array('_secure'=>true));
        }
    }
}
