<?php
class ControllerPaymentGspay extends Controller {
	protected function index() {
    	$this->data['button_confirm'] = $this->language->get('button_confirm');
		$this->data['button_back'] = $this->language->get('button_back');

		$this->load->model('checkout/order');
		
		$order_info = $this->model_checkout_order->getOrder($this->session->data['order_id']);
		
		$this->data['action'] = 'https://secure.checkout2pay.com/payment/pay.php';

		$this->data['sid'] = $this->config->get('gspay_account');
		$this->data['total'] = $this->currency->format($order_info['total'], $order_info['currency'], $order_info['value'], FALSE);
		$this->data['cart_order_id'] = $this->session->data['order_id'];
		$this->data['card_holder_name'] = $order_info['payment_firstname'] . ' ' . $order_info['payment_lastname'];
		$this->data['street_address'] = $order_info['payment_address_1'];
		$this->data['city'] = $order_info['payment_city'];
		$this->data['state'] = $order_info['payment_zone'];
		$this->data['zip'] = $order_info['payment_postcode'];
		$this->data['country'] = $order_info['payment_country'];
		$this->data['email'] = $order_info['email'];
		$this->data['phone'] = $order_info['telephone'];

		
		if ($this->cart->hasShipping()) {
			$this->data['ship_street_address'] = $order_info['shipping_address_1'];
			$this->data['ship_city'] = $order_info['shipping_city'];
			$this->data['ship_state'] = $order_info['shipping_zone'];
			$this->data['ship_zip'] = $order_info['shipping_postcode'];
			$this->data['ship_country'] = $order_info['shipping_country'];
		} else {
			$this->data['ship_street_address'] = $order_info['payment_address_1'];
			$this->data['ship_city'] = $order_info['payment_city'];
			$this->data['ship_statey'] = $order_info['payment_zone'];
			$this->data['ship_zip'] = $order_info['payment_postcode'];
			$this->data['ship_country'] = $order_info['payment_country'];			
		}
		
		$this->data['products'] = array();
		
		$products = $this->cart->getProducts();

		foreach ($products as $product) {
			$this->data['products'][] = array(
				'product_id'  => $product['product_id'],
				'name'        => $product['name'],
				'description' => $product['name'],
				'quantity'    => $product['quantity'],
				'price'		  => $this->currency->format($product['price'], $order_info['currency'], $order_info['value'], FALSE)
			);
		}
		// ===========================taxes

		$total_data = array();
		$total = 0;
		$taxes = $this->cart->getTaxes();
		 
		$this->load->model('checkout/extension');
		
		$sort_order = array(); 
		
		$results = $this->model_checkout_extension->getExtensions('total');
		
		foreach ($results as $key => $value) {
			$sort_order[$key] = $this->config->get($value['key'] . '_sort_order');
		}
		
		array_multisort($sort_order, SORT_ASC, $results);
		
		foreach ($results as $result) {
			if(in_array($result['key'],array('total','sub_total'))) continue;
			$this->load->model('total/' . $result['key']);

			$this->{'model_total_' . $result['key']}->getTotal($total_data, $total, $taxes);
		}
		
		$sort_order = array(); 
	  
		foreach ($total_data as $key => $value) {
      		$sort_order[$key] = $value['sort_order'];
		}

		array_multisort($sort_order, SORT_ASC, $total_data);

		foreach ($total_data as $t) {
			$this->data['products'][] = array(
				'product_id'  => $t['title'],
				'name'        => $t['title'],
				'description' => $t['title'],
				'quantity'    => 1,
				'price'		  => $this->currency->format($t['value'], $order_info['currency'], $order_info['value'], FALSE)
			);
		}



		// ===========================taxes


		$this->data['approve_url'] = HTTPS_SERVER . 'index.php?route=payment/gspay/success';
	
		/*
		if ($this->request->get['route'] != 'checkout/guest_step_3') {
			$this->data['return_url'] = HTTPS_SERVER . 'index.php?route=checkout/confirm';
		} else {
			$this->data['return_url'] = HTTPS_SERVER . 'index.php?route=checkout/guest_step_3';
		}
		*/
		
		if ($this->request->get['route'] != 'checkout/guest_step_3') {
			$this->data['decline_url'] = HTTPS_SERVER . 'index.php?route=checkout/payment';
		} else {
			$this->data['decline_url'] = HTTPS_SERVER . 'index.php?route=checkout/guest_step_2';
		}
		
		$this->id = 'payment';

		if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/payment/gspay.tpl')) {
			$this->template = $this->config->get('config_template') . '/template/payment/gspay.tpl';
		} else {
			$this->template = 'default/template/payment/gspay.tpl';
		}	
		
		$this->render();
	}
	

	public function success() {

        $url="https://secure.checkout2pay.com/payment/api.php";
        $values=array(
        'request'=>"
                <xml>
                <request>
                <transaction>
                        <transactionType>transactionStatus</transactionType>
                        <transactionTransactionID>".$this->request->get['transactionTransactionID']."</transactionTransactionID>
                </transaction>

                
                </request>
                </xml>
        
        ",
        );

	$params='';

        foreach ($values as $key=>$value) {
                $params.="$key=".urlencode($value)."&";
        }

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 180);

        curl_setopt($ch, CURLOPT_POSTFIELDS, $params);

       $result=curl_exec($ch);
        if (curl_errno($ch)>0) {
            exit("CURL ERROR:".curl_errno($ch).":".curl_error($ch));
        }
        curl_close($ch);


        $requestxml=simplexml_load_string($result);

	if(!$requestxml) return false;

	$this->load->model('checkout/order');

	switch ($requestxml->result->transactionStatus) {
		case 'approved':
		case 'test':
				$this->model_checkout_order->confirm($this->request->get['customerOrderID'], $this->config->get('gspay_order_status_id'));
				$this->model_checkout_order->update($this->request->get['customerOrderID'], $this->config->get('gspay_order_status_id'), $requestxml->result->transactionID, FALSE);

				$this->redirect(HTTP_SERVER . 'index.php?route=checkout/success');
				break;
	}	 
	$this->redirect(HTTP_SERVER . 'index.php?route=checkout/success');
	}
}
?>
