<?php
class ControllerExtensionPaymentGspay extends Controller {
	private $error = array();

	public function index() {
		$this->load->language('extension/payment/gspay');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('setting/setting');

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
			$this->model_setting_setting->editSetting('payment_gspay', $this->request->post);

			$this->session->data['success'] = $this->language->get('text_success');

			$this->response->redirect($this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=payment', true));
		}

		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		if (isset($this->error['email'])) {
			$data['error_email'] = $this->error['email'];
		} else {
			$data['error_email'] = '';
		}

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_extension'),
			'href' => $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=payment', true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('extension/payment/gspay', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['action'] = $this->url->link('extension/payment/gspay', 'user_token=' . $this->session->data['user_token'], true);

		$data['cancel'] = $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=payment', true);

		if (isset($this->request->post['payment_gspay_email'])) {
			$data['payment_gspay_email'] = $this->request->post['payment_gspay_email'];
		} else {
			$data['payment_gspay_email'] = $this->config->get('payment_gspay_email');
		}

		if (isset($this->request->post['payment_gspay_secret'])) {
			$data['payment_gspay_secret'] = $this->request->post['payment_gspay_secret'];
		} else {
			$data['payment_gspay_secret'] = $this->config->get('payment_gspay_secret');
		}

		if (isset($this->request->post['payment_gspay_total'])) {
			$data['payment_gspay_total'] = $this->request->post['payment_gspay_total'];
		} else {
			$data['payment_gspay_total'] = $this->config->get('payment_gspay_total');
		}

		if (isset($this->request->post['payment_gspay_order_status_id'])) {
			$data['payment_gspay_order_status_id'] = $this->request->post['payment_gspay_order_status_id'];
		} else {
			$data['payment_gspay_order_status_id'] = $this->config->get('payment_gspay_order_status_id');
		}

		if (isset($this->request->post['payment_gspay_pending_status_id'])) {
			$data['payment_gspay_pending_status_id'] = $this->request->post['payment_gspay_pending_status_id'];
		} else {
			$data['payment_gspay_pending_status_id'] = $this->config->get('payment_gspay_pending_status_id');
		}

		if (isset($this->request->post['payment_gspay_canceled_status_id'])) {
			$data['payment_gspay_canceled_status_id'] = $this->request->post['payment_gspay_canceled_status_id'];
		} else {
			$data['payment_gspay_canceled_status_id'] = $this->config->get('payment_gspay_canceled_status_id');
		}

		if (isset($this->request->post['payment_gspay_failed_status_id'])) {
			$data['payment_gspay_failed_status_id'] = $this->request->post['payment_gspay_failed_status_id'];
		} else {
			$data['payment_gspay_failed_status_id'] = $this->config->get('payment_gspay_failed_status_id');
		}

		if (isset($this->request->post['payment_gspay_chargeback_status_id'])) {
			$data['payment_gspay_chargeback_status_id'] = $this->request->post['payment_gspay_chargeback_status_id'];
		} else {
			$data['payment_gspay_chargeback_status_id'] = $this->config->get('payment_gspay_chargeback_status_id');
		}

		$this->load->model('localisation/order_status');

		$data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();

		if (isset($this->request->post['payment_gspay_geo_zone_id'])) {
			$data['payment_gspay_geo_zone_id'] = $this->request->post['payment_gspay_geo_zone_id'];
		} else {
			$data['payment_gspay_geo_zone_id'] = $this->config->get('payment_gspay_geo_zone_id');
		}

		$this->load->model('localisation/geo_zone');

		$data['geo_zones'] = $this->model_localisation_geo_zone->getGeoZones();

		if (isset($this->request->post['payment_gspay_status'])) {
			$data['payment_gspay_status'] = $this->request->post['payment_gspay_status'];
		} else {
			$data['payment_gspay_status'] = $this->config->get('payment_gspay_status');
		}

		if (isset($this->request->post['payment_gspay_sort_order'])) {
			$data['payment_gspay_sort_order'] = $this->request->post['payment_gspay_sort_order'];
		} else {
			$data['payment_gspay_sort_order'] = $this->config->get('payment_gspay_sort_order');
		}

		if (isset($this->request->post['payment_gspay_rid'])) {
			$data['payment_gspay_rid'] = $this->request->post['payment_gspay_rid'];
		} else {
			$data['payment_gspay_rid'] = $this->config->get('payment_gspay_rid');
		}

		if (isset($this->request->post['payment_gspay_custnote'])) {
			$data['payment_gspay_custnote'] = $this->request->post['payment_gspay_custnote'];
		} else {
			$data['payment_gspay_custnote'] = $this->config->get('payment_gspay_custnote');
		}

		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('extension/payment/gspay', $data));
	}

	protected function validate() {
		if (!$this->user->hasPermission('modify', 'extension/payment/gspay')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		if (!$this->request->post['payment_gspay_email']) {
			$this->error['email'] = $this->language->get('error_email');
		}

		return !$this->error;
	}
}