<?php
/*
  $Id: gspay.php,v 1.19 2003/01/29 19:57:15 hpdl Exp $

  osCommerce, Open Source E-Commerce Solutions
  http://www.oscommerce.com

  Copyright (c) 2003 osCommerce

  Released under the GNU General Public License
*/

function mydump($mix, $screen=true, $file=true) {
    ob_start();
    print_r($mix);

    $text=(ob_get_contents());
    ob_end_clean();

    if ($screen) {
        $text=htmlentities($text);
        echo "<div align=left><pre>$text<br></pre></div>";
    }

}

  class gspay {
    var $code, $title, $description, $enabled;

// class constructor
    function gspay() {
      global $order;

      $this->code = 'gspay';
      $this->title = MODULE_PAYMENT_GSPAY_TEXT_TITLE;
      $this->description = MODULE_PAYMENT_GSPAY_TEXT_DESCRIPTION;
      $this->sort_order = MODULE_PAYMENT_GSPAY_SORT_ORDER;
      $this->enabled = ((MODULE_PAYMENT_GSPAY_STATUS == 'True') ? true : false);

      if ((int)MODULE_PAYMENT_GSPAY_ORDER_STATUS_ID > 0) {
        $this->order_status = MODULE_PAYMENT_GSPAY_ORDER_STATUS_ID;
      }

      if (is_object($order)) $this->update_status();

      $this->form_action_url = 'https://secure.checkout2pay.com/payment/pay.php';
    }

// class methods
    function update_status() {
      global $order;


      if (!$order->info[orderID]) {
	      $order->info[orderID]=date('YmdHis')."-".rand(1000,9999);
      }

      if ( ($this->enabled == true) && ((int)MODULE_PAYMENT_GSPAY_ZONE > 0) ) {
        $check_flag = false;
        $check_query = tep_db_query("select zone_id from " . TABLE_ZONES_TO_GEO_ZONES . " where geo_zone_id = '" . MODULE_PAYMENT_GSPAY_ZONE . "' and zone_country_id = '" . $order->billing['country']['id'] . "' order by zone_id");
        while ($check = tep_db_fetch_array($check_query)) {
          if ($check['zone_id'] < 1) {
            $check_flag = true;
            break;
          } elseif ($check['zone_id'] == $order->billing['zone_id']) {
            $check_flag = true;
            break;
          }
        }

        if ($check_flag == false) {
          $this->enabled = false;
        }
      }
    }

    function javascript_validation() {
      $js = '  if (payment_value == "' . $this->code . '") {' . "\n" .
            '    var cc_number = document.checkout_payment.pm_gspay_cc_number.value;' . "\n" .
            '    if (cc_number == "" || cc_number.length < ' . CC_NUMBER_MIN_LENGTH . ') {' . "\n" .
            '      error_message = error_message + "' . MODULE_PAYMENT_GSPAY_TEXT_JS_CC_NUMBER . '";' . "\n" .
            '      error = 1;' . "\n" .
            '    }' . "\n" .
            '  }' . "\n";

      return $js;
    }

    function selection() {
      global $order;

      for ($i=1; $i < 13; $i++) {
        $expires_month[] = array('id' => sprintf('%02d', $i), 'text' => strftime('%B',mktime(0,0,0,$i,1,2000)));
      }

      $today = getdate(); 
      for ($i=$today['year']; $i < $today['year']+10; $i++) {
        $expires_year[] = array('id' => strftime('%y',mktime(0,0,0,1,1,$i)), 'text' => strftime('%Y',mktime(0,0,0,1,1,$i)));
      }

      $selection = array('id' => $this->code,
                         'module' => $this->title,
			 
			 );
      			

      return $selection;
    }

    function pre_confirmation_check() {
    }

    function confirmation() {
      global $HTTP_POST_VARS;

      $confirmation = array('title' => $this->title . ': ' . $this->cc_card_type,
			    );

      return $confirmation;
    }

    function process_button() {
      global $HTTP_POST_VARS, $order,$_SERVER;


        $USStates=array(
                "Alabama"=>"AL",
                "Alaska"=>"AK",
                "Alberta"=>"AB",
                "American Samoa"=>"AS",
                "Arizona"=>"AZ",
                "Arkansas"=>"AR",
                "AA"=>"Armed Forces - Americas",
                "AE"=>"Armed Forces - Europe",
                "AP"=>"Armed Forces - Pacific",
                "British Columbia"=>"BC",
                "California"=>"CA",
                "Colorado"=>"CO",
                "Connecticut"=>"CT",
                "Delaware"=>"DE",
                "District of Columbia"=>"DC",
                "Federated States of Micronesia"=>"FM",
                "Florida"=>"FL",
                "Georgia"=>"GA",
                "Guam"=>"GU",
                "Hawaii"=>"HI",
                "Idaho"=>"ID",
                "Illinois"=>"IL",
                "Indiana"=>"IN",
                "Iowa"=>"IA",
                "Kansas"=>"KS",
                "Kentucky"=>"KY",
                "Louisiana"=>"LA",
                "Maine"=>"ME",
                "Manitoba"=>"MB",
                "Marshall Islands"=>"MH",
                "Maryland"=>"MD",
                "Massachusetts"=>"MA",
                "Michigan"=>"MI",
                "Minnesota"=>"MN",
                "Mississippi"=>"MS",
                "Missouri"=>"MO",
                "Montana"=>"MT",
                "Nebraska"=>"NE",
                "Nevada"=>"NV",
                "New Brunswick"=>"NB",
                "New Hampshire"=>"NH",
                "New Jersey"=>"NJ",
                "New Mexico"=>"NM",
                "New York"=>"NY",
                "Newfoundland"=>"NF",
                "North Carolina"=>"NC",
                "North Dakota"=>"ND",
                "Northern Mariana Islands"=>"MP",
                "Northwest Territories"=>"NT",
                "Nova Scotia"=>"NS",
                "Ohio"=>"OH",
                "Oklahoma"=>"OK",
                "Ontario"=>"ON",
                "Oregon"=>"OR",
                "Palau"=>"PW",
                "Pennsylvania"=>"PA",
		"Prince Edward Island"=>"PE",
                "Puerto Rico"=>"PR",
                "Quebec"=>"QC",
                "Rhode Island"=>"RI",
                "Saskatchewan"=>"SK",
                "South Carolina"=>"SC",
                "South Dakota"=>"SD",
                "Tennessee"=>"TN",
                "Texas"=>"TX",
                "Utah"=>"UT",
                "Vermont"=>"VT",
                "Virgin Islands"=>"VI",
                "Virginia"=>"VA",
                "Washington"=>"WA",
                "West Virginia"=>"WV",
                "Wisconsin"=>"WI",
                "Wyoming"=>"WY",
                "Yukon"=>"YT",
        );
	$stateCode=$USStates[$order->customer['state']];
	$deliveryStateCode=$USStates[$order->delivery['state']];

      $process_button_string = tep_draw_hidden_field('siteID', MODULE_PAYMENT_GSPAY_LOGIN) .
                               tep_draw_hidden_field('OrderID', $order->info['orderID']) .
                               tep_draw_hidden_field('ApproveURL',  tep_href_link(FILENAME_CHECKOUT_PROCESS, '', 'SSL')).
                               tep_draw_hidden_field('customerFullName',$order->customer[firstname]." ".$order->customer[lastname] ) .
                               tep_draw_hidden_field('customerAddress', $order->customer['street_address']) .
                               tep_draw_hidden_field('customerCity', $order->customer['city']) .
                               tep_draw_hidden_field('customerStateCode', !empty($stateCode) ? $stateCode : 'XX') .
                               tep_draw_hidden_field('customerZip', $order->customer['postcode']) .
                               tep_draw_hidden_field('customerCountry', $order->customer['country']['title']) .
                               tep_draw_hidden_field('customerEmail', $order->customer['email_address']) .
                               tep_draw_hidden_field('customerPhone', $order->customer['telephone']) .

                               tep_draw_hidden_field('customerShippingFullName',$order->delivery[firstname]." ".$order->customer[lastname] ) .
                               tep_draw_hidden_field('customerShippingAddress', $order->delivery['street_address']) .
                               tep_draw_hidden_field('customerShippingCity', $order->delivery['city']) .
                               tep_draw_hidden_field('customerShippingStateCode', !empty($deliveryStateCode) ? $deliveryStateCode: 'XX') .
                               tep_draw_hidden_field('customerShippingZip', $order->delivery['postcode']) .
                               tep_draw_hidden_field('customerShippingCountry', $order->delivery['country']['title']) .
                               tep_draw_hidden_field('customerShippingEmail', $order->delivery['email_address']) .
                               tep_draw_hidden_field('customerShippingPhone', $order->customer['telephone']) .
      				
			       "";


	foreach ($order->products as $key => $product) {
		$add_info="";
		if (is_array($product[attributes])) foreach ($product[attributes] as $attr) {
			$add_info.=$attr[option].":".$attr[value]." ";
		}
		$process_button_string .= tep_draw_hidden_field("Amount[$key]", $product['final_price']) ;
		$process_button_string .= tep_draw_hidden_field("Qty[$key]", $product['qty']) ;
		$process_button_string .= tep_draw_hidden_field("OrderDescription[$key]", $product['name'].($add_info ? " ($add_info)" : "")) ;
		$totalprice+=$product['final_price'];
	}
	if ($order->info[tax]>0) {
		$key++;
		$process_button_string .= tep_draw_hidden_field("Amount[$key]", $order->info[tax]) ;
		$process_button_string .= tep_draw_hidden_field("Qty[$key]",1) ;
		$process_button_string .= tep_draw_hidden_field("OrderDescription[$key]",'Tax') ;
		$totalprice+=$order->info[tax];
	}
	if ($order->info[shipping_cost]>0) {
		$key++;
		$process_button_string .= tep_draw_hidden_field("Amount[$key]", $order->info[shipping_cost]) ;
		$process_button_string .= tep_draw_hidden_field("Type[$key]",'Shipping') ;
		$process_button_string .= tep_draw_hidden_field("OrderDescription[$key]",$order->info[shipping_method]) ;
		$totalprice+=$order->info[shipping_cost];
	}
	if (($pd=$order->info[total]-$totalprice)<-.05) {
		$key++;
		$process_button_string .= tep_draw_hidden_field("Amount[$key]",$pd) ;
		$process_button_string .= tep_draw_hidden_field("Qty[$key]",'1') ;
		$process_button_string .= tep_draw_hidden_field("OrderDescription[$key]",'Discounts');
		$hash_amount.=number_format($pd, 2)."|";
		$hash_qty.= "1|";
	}

      return $process_button_string;
    }

    function before_process() {
	    global $order;
      global $HTTP_POST_VARS, $HTTP_GET_VARS;
	$HTTP_GET_VARS=is_array($_GET) ? $_GET : $HTTP_GET_VARS;
	$HTTP_POST_VARS=is_array($_POST) ? $_POST : $HTTP_POST_VARS;



	$url="https://secure.checkout2pay.com/payment/api.php";
	$values=array(
	'request'=>"
		<xml>
		<request>
		<transaction>
		        <transactionType>transactionStatus</transactionType>
		        <transactionTransactionID>".$HTTP_GET_VARS[transactionTransactionID]."</transactionTransactionID>
		</transaction>

		
		</request>
		</xml>
	
	",
	);

	foreach ($values as $key=>$value) {
		$params.="$key=".urlencode($value)."&";
	}


	$ch = curl_init();
	curl_setopt($ch, CURLOPT_URL, $url);
	curl_setopt($ch, CURLOPT_POST, 1);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
	curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 180);
		 
	curl_setopt($ch, CURLOPT_POSTFIELDS, $params);

	ob_start();
	curl_exec($ch);
        if (curl_errno($ch)>0) {
	    exit("CURL ERROR:".curl_errno($ch).":".curl_error($ch));
	}
	$result = ob_get_contents();
	ob_end_clean();
	curl_close($ch);


	$requestxml=$result;
	$p = xml_parser_create();
	if (!  xml_parse_into_struct($p, $requestxml, $vals, $index)) {
		tep_redirect(tep_href_link(FILENAME_CHECKOUT_PAYMENT, 'error_message=' . urlencode(MODULE_PAYMENT_GSPAY_TEXT_ERROR_MESSAGE), 'SSL', true, false));
	}
	xml_parser_free($p);


	if (is_array($vals)) foreach ($vals as $key=>$value) {
		if ($value[type]=='complete') {
			$transinfo[$value[tag]]=trim($value[value]);
		}
	}


	if (!(($transinfo[TRANSACTIONSTATUS]=='approved' || $transinfo[TRANSACTIONSTATUS]=='test' ) && $transinfo[TRANSACTIONTYPE]=='sale')) {
		tep_redirect(tep_href_link(FILENAME_CHECKOUT_PAYMENT, 'error_message=' . urlencode($transinfo[TRANSACTIONMESSAGE]), 'SSL', true, false));
	}

						

    }

    function after_process() {
      return false;
    }

    function get_error() {
      global $HTTP_GET_VARS;

      $error = array('title' => MODULE_PAYMENT_GSPAY_TEXT_ERROR,
                     'error' => stripslashes(urldecode($HTTP_GET_VARS['error'])));

      return $error;
    }

    function check() {
      if (!isset($this->_check)) {
        $check_query = tep_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_PAYMENT_GSPAY_STATUS'");
        $this->_check = tep_db_num_rows($check_query);
      }
      return $this->_check;
      return true;
    }

    function install() {
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) values ('Enable GSPay Module', 'MODULE_PAYMENT_GSPAY_STATUS', 'True', 'Do you want to accept GSPay payments?', '6', '0', 'tep_cfg_select_option(array(\'True\', \'False\'), ', now())");
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Site ID Number', 'MODULE_PAYMENT_GSPAY_LOGIN', '0001', 'Your GSPAY siteID Number', '6', '0', now())");
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Sort order of display.', 'MODULE_PAYMENT_GSPAY_SORT_ORDER', '0', 'Sort order of display. Lowest is displayed first.', '6', '0', now())");
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, use_function, set_function, date_added) values ('Payment Zone', 'MODULE_PAYMENT_GSPAY_ZONE', '0', 'If a zone is selected, only enable this payment method for that zone.', '6', '2', 'tep_get_zone_class_title', 'tep_cfg_pull_down_zone_classes(', now())");
    }

    function remove() {
      tep_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '", $this->keys()) . "')");
    }

    function keys() {
      return array('MODULE_PAYMENT_GSPAY_STATUS', 'MODULE_PAYMENT_GSPAY_LOGIN', 'MODULE_PAYMENT_GSPAY_TESTMODE', 'MODULE_PAYMENT_GSPAY_EMAIL_MERCHANT', 'MODULE_PAYMENT_GSPAY_ZONE', 'MODULE_PAYMENT_GSPAY_ORDER_STATUS_ID', 'MODULE_PAYMENT_GSPAY_SORT_ORDER');
    }
  }
?>
