<?php
if(!defined('ABSPATH')) exit; // Exit if accessed directly

require_once('aelia-wc-requirementscheck.php');

/**
 * Checks that plugin's requirements are met.
 */
class Aelia_WC_AFC_RequirementsChecks extends Aelia_WC_RequirementsChecks {
	// @var string The namespace for the messages displayed by the class.
	protected $text_domain = 'wc_aelia_afc';
	// @var string The plugin for which the requirements are being checked. Change it in descendant classes.
	protected $plugin_name = 'Aelia Foundation Classes for WooCommerce';

	/**
	 * The minimum version of PHP required by the plugin.
	 *
	 * @var string
	 * @since 2.1.1.201208
	 */
	protected $required_php_version = '7.1';

	// @var array An array of WordPress plugins (name => version) required by the plugin.
	protected $required_plugins = array(
		
		'WooCommerce' => '3.0',
		
	);

	/**
	 * Factory method. It MUST be copied to every descendant class, as it has to
	 * be compatible with PHP 5.2 and earlier, so that the class can be instantiated
	 * in any case and and gracefully tell the user if PHP version is insufficient.
	 *
	 * @return Aelia_WC_AFC_RequirementsChecks
	 */
	public static function factory() {
		$instance = new self();
		return $instance;
	}
}
