<?php if(!defined('ABSPATH')) exit; // Exit if accessed directly
	if(!defined('AELIA_WC_SKRILL_SHOW_FIELDS')) {
		define('AELIA_WC_SKRILL_SHOW_FIELDS', false);
	}

	// View is included by the GSPAY gateway instance, which is what
	// "$this" refers to. This assignment is done just to improve code
	// readability
	$gateway_gspay = $this;

	if(property_exists($gateway_gspay, 'testmode') && $gateway_gspay->testmode) {
		$gspay_url = $gateway_gspay->test_url;
	}
	else {
		$gspay_url = $gateway_gspay->live_url;
	}

	if($gateway_gspay->debug_mode()) {
		echo '<p class="debug">';
		echo __('Debug mode is active, therefore automatic redirection to GSPAY is disabled. ' .
						'please click on the button below to submit the payment to GSPAY.',
						property_exits($gateway_gspay, 'textdomain') ? $gateway_gspay->textdomain : 'Domain not set');
		echo '</p>';
	}
	else {
		// JavaScript to automatically submit the form is loaded only when not debugging
		$gspay_js_url = $gateway_gspay->url('js_frontend') . '/gspay.js';
		echo '<script type="text/javascript" src="' . $gspay_js_url . '"></script>';
	}
?>

<form id="gspay_form" method="post" action="<?php echo $gspay_url; ?>">
	<?php
		// When debugging, display the fields
		$field_type = (AELIA_WC_SKRILL_SHOW_FIELDS === true) ? 'text' : 'hidden';
		$gspay_fields = array();
		// $gspay_args is a variable loaded just before including this view, thus
		// it's in this code's scope
		foreach($gspay_args as $field_name => $value) {
			$gspay_fields[] = '<input type="' . $field_type . '" name="'. esc_attr($field_name) .
													 '" value="' . esc_attr($value) . '" />';
		}
		echo implode("\n", $gspay_fields);
	?>
	<input id="gspay_submit" type="submit" value="<?php echo __('Pay via GSPAY', $gateway_gspay->textdomain); ?>">
</form>
